/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.datasource.db.DBServiceImpl;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBService;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class DBIteratorImpl<T extends AbstractDBObject>
extends UnicastRemoteObject
implements DBIterator<T> {
    private DBService service = null;
    private Connection conn = null;
    private T object = null;
    private String filter = "";
    private String order = "";
    private int limit = -1;
    private ArrayList params = new ArrayList();
    private String joins = "";
    private List<T> list = new ArrayList<T>();
    private int index = 0;
    private boolean initialized = false;

    DBIteratorImpl(T object, DBServiceImpl service) throws RemoteException {
        if (object == null) {
            throw new RemoteException("given object type is null");
        }
        this.object = object;
        this.service = service;
        this.conn = service.getConnection();
        if (this.conn == null) {
            throw new RemoteException("given connection is null");
        }
    }

    DBIteratorImpl(T object, ArrayList list, DBServiceImpl service) throws RemoteException {
        this(object, service);
        if (list == null) {
            throw new RemoteException("given list is null");
        }
        try {
            for (int i = 0; i < list.size(); ++i) {
                AbstractDBObject o = (AbstractDBObject)service.createObject(object.getClass(), (String)list.get(i));
                this.list.add(o);
            }
        }
        catch (Exception e) {
            throw new RemoteException("unable to create list", e);
        }
        this.initialized = true;
    }

    @Override
    public void setOrder(String order) throws RemoteException {
        if (this.initialized) {
            return;
        }
        this.order = " " + order;
    }

    @Override
    public void setLimit(int i) throws RemoteException {
        this.limit = i;
    }

    @Override
    public void addFilter(String filter) throws RemoteException {
        this.addFilter(filter, null);
    }

    @Override
    public void addFilter(String filter, Object ... p) throws RemoteException {
        if (this.initialized) {
            return;
        }
        if (filter == null) {
            return;
        }
        this.filter = "".equals(this.filter) ? filter : this.filter + " and " + filter;
        if (p != null) {
            for (Object o : p) {
                this.params.add(o);
            }
        }
    }

    @Override
    public void join(String table) throws RemoteException {
        if (this.initialized) {
            return;
        }
        if (table == null) {
            return;
        }
        this.joins = this.joins + ", " + table;
    }

    private String prepareSQL() {
        String sql = ((AbstractDBObject)this.object).getListQuery();
        if (sql.indexOf(" where ") != -1) {
            if (!"".equals(this.filter)) {
                sql = sql + " and " + this.filter;
            }
        } else if (this.filter != null && !"".equals(this.filter)) {
            sql = sql + this.joins + " where " + this.filter;
        }
        if (sql.indexOf(" order ") == -1) {
            sql = sql + this.order;
        }
        if (sql.indexOf(" limit ") == -1 && this.limit > 0) {
            sql = sql + " limit " + Integer.toString(this.limit);
        }
        return sql;
    }

    private void init() throws RemoteException {
        if (this.initialized) {
            return;
        }
        Object stmt = null;
        String sql = null;
        ResultSet rs = null;
        try {
            sql = this.prepareSQL();
            stmt = this.conn.prepareStatement(sql);
            for (int i = 0; i < this.params.size(); ++i) {
                Object p = this.params.get(i);
                if (p == null) {
                    stmt.setNull(i + 1, 1111);
                    continue;
                }
                stmt.setObject(i + 1, p);
            }
            Logger.debug((String)("executing sql query: " + stmt));
            rs = stmt.executeQuery();
            while (rs.next()) {
                AbstractDBObject o = (AbstractDBObject)this.service.createObject(this.object.getClass(), null);
                o.setID(rs.getString(o.getIDField()));
                o.fill(rs);
                this.list.add(o);
            }
            this.initialized = true;
        }
        catch (Exception e) {
            String s = stmt == null ? null : stmt.toString();
            throw new RemoteException("unable to init iterator. " + (s != null ? "statement: " + s : ""), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean hasNext() throws RemoteException {
        this.init();
        return this.index < this.list.size() && this.list.size() > 0;
    }

    @Override
    public T next() throws RemoteException {
        this.init();
        try {
            return (T)((AbstractDBObject)this.list.get(this.index++));
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public T previous() throws RemoteException {
        this.init();
        try {
            return (T)((AbstractDBObject)this.list.get(this.index--));
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public int size() throws RemoteException {
        this.init();
        return this.list.size();
    }

    @Override
    public void begin() throws RemoteException {
        this.index = 0;
    }

    @Override
    public T contains(T other) throws RemoteException {
        this.init();
        if (other == null) {
            return null;
        }
        if (!other.getClass().equals(this.object.getClass())) {
            return null;
        }
        AbstractDBObject object = null;
        for (int i = 0; i < this.list.size(); ++i) {
            object = (AbstractDBObject)this.list.get(i);
            if (!object.equals((GenericObject)other)) continue;
            return (T)object;
        }
        return null;
    }
}

